unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, IniFiles,
  UIniFile, Unit1;

const cEXT = '.INI';

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnSPR1: TBitBtn;
    Memo: TMemo;
    btnSPR2: TBitBtn;
    btnSPR3: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSPR3Click(Sender: TObject);
    procedure btnSPR2Click(Sender: TObject);
    procedure btnSPR1Click(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);

  private
   fName : String;

  public
    procedure Spr1();
    procedure Spr2();
    procedure Spr3();    
  end;

var
  Form2: TForm2;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm2.btnCLOSEClick(Sender: TObject);
begin
   Close();
end;

procedure TForm2.btnSPR1Click(Sender: TObject);
begin
	Spr1();
end;

procedure TForm2.btnSPR2Click(Sender: TObject);
begin
	Spr2();
end;

procedure TForm2.btnSPR3Click(Sender: TObject);
begin
	Spr3();
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
	fName := ExtractFilePath(Application.ExeName) + 'APP.INI';
end;

procedure TForm2.FormShow(Sender: TObject);
begin
   Memo.Clear();
end;

procedure TForm2.Spr1();
var
   ini : MIniFile;

begin
   // tworzy wszystkie elementy sekcje
   try
	   ini := MIniFile.Create(fName);
   	ini.Sprawdz_wszystkie_sekcje();
   finally
		FreeAndNil(ini);
   end;
end;

procedure TForm2.Spr2();
var
   ini          : MIniFile;
   nazwa_sekcji : String;
   txt          : String;
   ilEL         : Integer;
   lp           : Integer;

begin
   nazwa_sekcji := '';
   txt          := '';
   ilEL         := 0;
   lp           := 0;

   // wczytaj wszystkie elementy wybranej sekcji
   Memo.Clear();

   nazwa_sekcji := 'DRZEWA';

   try
      ini := MIniFile.Create(fName);
      ini.Wczytaj_el_sekcji(nazwa_sekcji);
      ilEL := ini.Count();

      if(ilEL >= 0) then
   	begin
      	Memo.Lines.Add(nazwa_sekcji);

         for lp := 0 to ilEL-1 do
         begin
            txt := ini.ItemsKeys.Strings[lp];
            Memo.Lines.Add(txt);
         end;
      end;
   finally
      FreeAndNil(ini);
   end;
end;

procedure TForm2.Spr3();
var
   nazwa_sekcji : String;
   txt          : String;
   lp           : Integer;
   ilEL         : Integer;
   Item         : String;
   ini          : MIniFile;
   Lista        : TStringList;

begin
   // dodaj nowy wpis do sekcji
   try
      ini := MIniFile.Create(fName);

      if ini.
      Sekcja_istnieje('DRZEWA') then
   	begin
         ini.Dopisz_do_sekcji_AsString('DRZEWA', 'Buk', '');
      end;
   finally
      FreeAndNil(ini);
   end;

   // pod dopisaniu zaczytujemy sekcj jeszcze raz
   // i wywietlamy wyniki
end;

end.

